/*global jQuery */
(function($){
  
    // USE STRICT
    "use strict";

    var woocommerce_buying_guide = {

        init : function (options) {

        	woocommerce_buying_guide.defaults = {
				live_filter: "1",
				filter_after_choice: "1",
			};

			woocommerce_buying_guide.settings = $.extend( {}, woocommerce_buying_guide.defaults, options );
			woocommerce_buying_guide._defaults = woocommerce_buying_guide.defaults;

            // Basic variables
            woocommerce_buying_guide.url = location.href;
            woocommerce_buying_guide.url_parameters = woocommerce_buying_guide.url.split('?');
            woocommerce_buying_guide.url_without_paramter = woocommerce_buying_guide.url.split('?')[0].split("#")[0];
            woocommerce_buying_guide.base_url = woocommerce_buying_guide.url.substring(0, woocommerce_buying_guide.url.indexOf('/', 14));
            woocommerce_buying_guide.pathname = location.pathname;
            woocommerce_buying_guide.pathSplit = woocommerce_buying_guide.pathname.split("/");
            woocommerce_buying_guide.title = document.title;

            woocommerce_buying_guide.initTooltips();
            woocommerce_buying_guide.watchLink();
            woocommerce_buying_guide.watchChoices();
            woocommerce_buying_guide.checkSuccess();
            woocommerce_buying_guide.watchModal();

            woocommerce_buying_guide.products = [];
            woocommerce_buying_guide.choicesMade = [];

        },
		initTooltips : function () {
			$('.tooltip-trigger').tooltip();
	   	},
	   	watchLink : function () {

	   		$('.woocommerce-buying-guide-link, .woocommerce-buying-guide-start').on('click', function(e) {

	   			e.preventDefault();

	   			$('.products .product').fadeIn();

	   			woocommerce_buying_guide.products = [];
	   			woocommerce_buying_guide.choicesMade = [];

	   			var buying_guide_link = $(this);
				var id = buying_guide_link.data('id');

				$('.woocommerce-buying-guide-success').fadeOut();
				$('.woocommerce-buying-guide-error').fadeOut();

	   			$('#woocommerce-buying-guide-start-container-' + id).fadeOut( function() {
	   				$('#woocommerce-buying-guide-progress-' + id ).fadeIn();
	   				$('#woocommerce-buying-guide-breadcrumb-' + id ).fadeIn();
	   				$('#woocommerce-buying-guide-progress-bar-' +  id).css('width', 0 + '%');

	   				$('#woocommerce-buying-guide-progress-breadcrumb-1').addClass('active');
	   				$('#woocommerce-buying-guide-question-choice-' + id + ' #woocommerce-buying-guide-question-container-1').fadeIn();
	   			});
	   		});
	   	},
	   	watchChoices : function () {
	   		$('.woocommerce-buying-guide-choice-radio').on('click', function(e) {
	   			e.preventDefault();

	   			var choice = $(this);

	   			var products = choice.data('products').toString().split(',');
	   			var buying_guide = choice.data('buying-guide');
	   			var question = choice.data('question');
	   			var next = question + 1;

	   			var questionText = $('#woocommerce-buying-guide-question-container-' + question + ' .woocommerce-buying-guide-question').text();
	   			var choiceText = choice.find('.woocommerce-buying-guide-choice-radio-text').html();

	   			woocommerce_buying_guide.choicesMade.push(questionText + ': ' + choiceText);
   				woocommerce_buying_guide.products.push(products);
   				
   				var totalQuestion = $('#woocommerce-buying-guide-question-choice-' +  buying_guide+ ' .woocommerce-buying-guide-question-container').length;
   				var step = 100 / totalQuestion;
   	
	   			$('#woocommerce-buying-guide-question-choice-' +  buying_guide+ ' #woocommerce-buying-guide-question-container-' + question).fadeOut(function() {
	   				var nextQuestion = $('#woocommerce-buying-guide-question-container-' + next);

	   				$('#woocommerce-buying-guide-progress-bar-' +  buying_guide).css('width', step * question + '%');
	   				$('#woocommerce-buying-guide-progress-breadcrumb-' +  question).removeClass('active');
	   				$('#woocommerce-buying-guide-progress-breadcrumb-' +  next).addClass('active');

	   				if(nextQuestion.length > 0 ) {

	   					if(woocommerce_buying_guide.settings.live_filter === "1" && woocommerce_buying_guide.settings.filter_after_choice === "1") {
		   					
							var siteProducts = $('.products .product');
							$(siteProducts).each(function(i, index) {
								var classes = $(this).attr('class');

							    var prod = classes.match(/post-\d+/);
								prod = prod[0].substring(5);

								if(jQuery.inArray(prod, products) !== -1) {
									$('.post-' + prod).fadeIn().removeClass('first');;
								} else {
									$('.post-' + prod).fadeOut();
								}
							});
   						}

	   					$('#woocommerce-buying-guide-question-choice-' +  buying_guide+ ' #woocommerce-buying-guide-question-container-' + next).fadeIn();

	   				} else {

	   					var result = woocommerce_buying_guide.products.shift().reduce(function(res, v) {
	   						console.log(res);
						    if (res.indexOf(v) === -1 && woocommerce_buying_guide.products.every(function(a) {
						    	console.log(a);
						        return a.indexOf(v) !== -1;
						    })) res.push(v);
						    return res;
						}, []);

						if(woocommerce_buying_guide.settings.live_filter === "1") {

							$('#woocommerce-buying-guide-modal-' + buying_guide).modal('hide');
							$('#woocommerce-buying-guide-start-container-' + buying_guide).fadeOut();

							var siteProducts = $('.products .product');
							if(result.length < 1) {
								$('#woocommerce-buying-guide-error-' + buying_guide).fadeIn();
								siteProducts.fadeOut();
							} else {
								$('#woocommerce-buying-guide-success-' + buying_guide).fadeIn();
								$('#woocommerce-buying-guide-success-choices-made-' + buying_guide).html( woocommerce_buying_guide.choicesMade.join('<br/>') );
	
								$(siteProducts).each(function(i, index) {
									var classes = $(this).attr('class');

								    var prod = classes.match(/post-\d+/);
									prod = prod[0].substring(5);

									if(jQuery.inArray(prod, result) !== -1) {
										$('.post-' + prod).fadeIn().removeClass('first');;
									} else {
										$('.post-' + prod).fadeOut();
									}
								});
							}							
						} else {
							window.location.href = woocommerce_buying_guide.url_without_paramter + '?woocommerce-buying-guide=' + buying_guide + '&woocommerce-buying-guide-products=' + result.join();
						}
	   					return false;
	   				}
	   			});
   			});
	   	},
	   	checkSuccess : function () {
	   		var buying_guide_id = woocommerce_buying_guide.findGetParameter('woocommerce-buying-guide');
	   		var products_found = woocommerce_buying_guide.findGetParameter('woocommerce-buying-guide-products');

	   		
	   		if(buying_guide_id !== "") {
	   			
	   			if(products_found !== "") {
	   				
		   			$('#woocommerce-buying-guide-start-container-' + buying_guide_id).fadeOut(function() {
		   				$('#woocommerce-buying-guide-success-' + buying_guide_id).fadeIn();
		   			});
	   			} else {
	   				$('#woocommerce-buying-guide-start-container-' + buying_guide_id).fadeOut(function() {
		   				$('#woocommerce-buying-guide-error-' + buying_guide_id).fadeIn();
		   			});
	   			}
	   		}
	   	},
	   	watchModal : function () {
	   		$('.woocommerce-buying-guide-modal-start').on('click', function(e) {
	   			e.preventDefault();

	   			var buying_guide_link = $(this);
				var id = buying_guide_link.data('id');

				$('.products .product').fadeIn();

				$('.woocommerce-buying-guide-success').fadeOut();
				$('.woocommerce-buying-guide-error').fadeOut();

				$('.woocommerce-buying-guide-question-container').fadeOut();

				$('#woocommerce-buying-guide-modal-' + id).modal('show');
				$('#woocommerce-buying-guide-progress-' + id ).fadeIn();
   				$('#woocommerce-buying-guide-question-choice-' + id + ' #woocommerce-buying-guide-question-container-1').fadeIn();

	   		});

	   		$('.woocommerce-buying-guide-modal-close').on('click', function(e) {
	   			e.preventDefault();

	   			console.log('closed');

	   			var close_link = $(this);
	   			var id = close_link.data('id');

	   			$('#woocommerce-buying-guide-start-container-' + id).fadeIn();

	   		});

	   	},
		findGetParameter : function(parameterName) {
		    var result = null,
		        tmp = [];
		    location.search
		    .substr(1)
		        .split("&")
		        .forEach(function (item) {
		        tmp = item.split("=");
		        if (tmp[0] === parameterName) result = decodeURIComponent(tmp[1]);
		    });
		    return result;
		}
    };

    jQuery(document).ready(woocommerce_buying_guide.init(buying_guide_options));

})(jQuery);